<?php


namespace app\common\model;

use think\facade\Request;
use think\Model;

class Admin extends Model
{

    protected $autoWriteTimestamp = true;
    protected $createTime = 'create_time';
    protected $updateTime = 'update_time';

    public function getLoginTimeAttr($val)
    {
        if ($val)
            return date('Y-m-d H:i:s');
        else
            return '暂未登录';
    }

    /**
     * 登录数据验证
     * @return string
     * @throws \think\db\exception\DataNotFoundException
     * @throws \think\db\exception\DbException
     * @throws \think\db\exception\ModelNotFoundException
     */
    public function checkLogin()
    {
        $username = Request::post('username', '', 'trim');
        $password = request()->post('password', '', 'trim');
        $code = Request::post('code', '', 'trim');
        if (empty($username) || empty($password)) {
            return json(['status' => 101, 'msg' => '账号或者密码为空']);
        }
        if (!captcha_check($code)) {
            return json(['status' => 102, 'msg' => '验证码错误']);
        }
        $info = $this->where(['username' => $username])->find();
        if (empty($info)) {
            return json(['status' => 103, 'msg' => '账号或者密码错误', 'type' => 1]);
        }
        if ($info['password'] != md5($password)) {
            return json(['status' => 104, 'msg' => '账号或者密码错误', 'type' => 2]);
        }
        if ($info['status'] != 1) {
            return json(['status' => 105, 'msg' => '该账号已被禁用']);
        }
        if (!Request::checkToken('__token__')) {
            return json(['status' => 100, 'msg' => '表单验证有误']);
        }
        $info['rules'] = Role::where(['id' => $info['role_id'], 'status' => 1])->value('rules');
        $data['login_time'] = time();
        $data['login_ip'] = Request::ip();
        $this->where(['id' => $info['id']])->save($data);
        session('adminInfo', $info);
        return json(['status' => 200, 'msg' => '登录成功', 'url' => url('Index/index')->__toString()]);
    }

}
